using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        string[] inputs = Console.ReadLine().Split();
        int N = int.Parse(inputs[0]);
        int K = int.Parse(inputs[1]);

        inputs = Console.ReadLine().Split();
        HashSet<int> shopLocations = new HashSet<int>();
        foreach (string input in inputs)
        {
            shopLocations.Add(int.Parse(input));
        }

        inputs = Console.ReadLine().Split();
        List<int> populations = new List<int>();
        foreach (string input in inputs)
        {
            populations.Add(int.Parse(input));
        }

        int minShops = MinShopsForMonopoly(N, K, shopLocations, populations);
        Console.WriteLine(minShops);
    }

    static int MinShopsForMonopoly(int N, int K, HashSet<int> shopLocations, List<int> populations)
    {
        populations.Sort(); 


        foreach (int location in shopLocations)
        {
            if (populations[location - 1] > populations.Sum() / 2)
            {
                return 0;
            }
        }

        int shopsNeeded = 0;
        int populationCovered = 0;
        foreach (int population in populations)
        {
            populationCovered += population;
            shopsNeeded++;
            if (populationCovered > populations.Sum() / 2)
            {
                return shopsNeeded;
            }
        }


        return -1;
    }
}